### Scripts for Session 4: modelling in R

print(names(Cars93), quote = F)

require(lattice)
p1 <- xyplot(MPG.city ~ Weight, Cars93)
p2 <- xyplot(1000/MPG.city ~ Weight, Cars93)
print(p1, c(0, 0.5, 0.5, 1), more = T)
print(p2, c(0.5, 0.5, 1, 1))

Cars93.lm <- lm(MPG.city ~ Weight, Cars93, singular.ok = T)
boxcox(Cars93.lm, lambda = seq(-2, -0.5, len=15))
Cars93.lm <- update(Cars93.lm, 1000/MPG.city ~ .)

Cars93.lm1 <- lm(1000/MPG.city ~ Type*(Weight+Horsepower+Length), Cars93) 

dropterm(Cars93.lm1, test="F", k = log(93))

Cars93.step <- stepAIC(Cars93.lm1, scope = list(lower = ~ Weight,
	upper = ~ Type*(Min.Price + Price + Max.Price + AirBags + DriveTrain + 
	Cylinders + EngineSize + Horsepower + RPM + Rev.per.mile + 
	Fuel.tank.capacity + Passengers + Length + Wheelbase + Width + 
	Turn.circle + Weight + Origin)), k = log(93))

dropterm(Cars93.step, test = "F", k = log(93))

Cars93.AIC <- stepAIC(Cars93.lm, scope = list(lower = ~ Weight,
	upper = ~ Type*(Min.Price + Price + Max.Price + AirBags + DriveTrain + 
	Cylinders + EngineSize + Horsepower + RPM + Rev.per.mile + 
	Fuel.tank.capacity + Passengers + Length + Wheelbase + Width + 
	Turn.circle + Weight + Origin)), k = 2)

dropterm(Cars93.AIC, test = "F", sorted = T)

Cars93.AIC <- update(Cars93.AIC, .~.-Wheelbase)
dropterm(Cars93.AIC, test = "F", sorted = T)
Cars93.AIC <- update(Cars93.AIC, .~.-Horsepower)
dropterm(Cars93.AIC, test = "F", sorted = T)
Cars93.AIC <- update(Cars93.AIC, .~.-Cylinders)
dropterm(Cars93.AIC, test = "F", sorted = T)

summary(Cars93.step)
summary(Cars93.AIC)

par(mfrow=c(2,2))
plot(fitted(Cars93.step), resid(Cars93.step))
abline(h = 0, lty = 4, col = 3)
qqnorm(resid(Cars93.step))
qqline(resid(Cars93.step))

#### now for something completely different

require(rpart)
Cars93.tm <- rpart(I(1000/MPG.city) ~ Type + Min.Price + Price + 
	Max.Price + AirBags + DriveTrain + 
	Cylinders + EngineSize + Horsepower + RPM + Rev.per.mile + 
	Fuel.tank.capacity + Passengers + Length + Wheelbase + Width + 
	Turn.circle + Weight + Origin, Cars93)
	
plotcp(Cars93.tm)
plot(Cars93.tm); text(Cars93.tm, col = "green4")


plot(predict(Cars93.tm), predict(Cars93.AIC))
abline(0, 1, lty = "solid", col = "red")

require(randomForest)
Cars93.rf <- randomForest(1000/MPG.city ~ Type + Min.Price + Price +
	Max.Price + AirBags + DriveTrain +
	Cylinders + EngineSize + Horsepower + RPM + Rev.per.mile +
	Fuel.tank.capacity + Passengers + Length + Wheelbase + Width +
	Turn.circle + Weight + Origin, Cars93)

plot(predict(Cars93.rf), predict(Cars93.AIC))
abline(0, 1, lty = "solid", col = "red")

